//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armfluidrelay

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ContainersClient contains the methods for the FluidRelayContainers group.
// Don't use this type directly, use NewContainersClient() instead.
type ContainersClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewContainersClient creates a new instance of ContainersClient with the specified values.
// subscriptionID - The subscription id (GUID) for this resource.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewContainersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ContainersClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ContainersClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Delete - Delete a Fluid Relay container.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-01
// resourceGroup - The resource group containing the resource.
// fluidRelayServerName - The Fluid Relay server resource name.
// fluidRelayContainerName - The Fluid Relay container resource name.
// options - ContainersClientDeleteOptions contains the optional parameters for the ContainersClient.Delete method.
func (client *ContainersClient) Delete(ctx context.Context, resourceGroup string, fluidRelayServerName string, fluidRelayContainerName string, options *ContainersClientDeleteOptions) (ContainersClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroup, fluidRelayServerName, fluidRelayContainerName, options)
	if err != nil {
		return ContainersClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ContainersClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ContainersClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return ContainersClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ContainersClient) deleteCreateRequest(ctx context.Context, resourceGroup string, fluidRelayServerName string, fluidRelayContainerName string, options *ContainersClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.FluidRelay/fluidRelayServers/{fluidRelayServerName}/fluidRelayContainers/{fluidRelayContainerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroup == "" {
		return nil, errors.New("parameter resourceGroup cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroup}", url.PathEscape(resourceGroup))
	if fluidRelayServerName == "" {
		return nil, errors.New("parameter fluidRelayServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fluidRelayServerName}", url.PathEscape(fluidRelayServerName))
	if fluidRelayContainerName == "" {
		return nil, errors.New("parameter fluidRelayContainerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fluidRelayContainerName}", url.PathEscape(fluidRelayContainerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a Fluid Relay container.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-01
// resourceGroup - The resource group containing the resource.
// fluidRelayServerName - The Fluid Relay server resource name.
// fluidRelayContainerName - The Fluid Relay container resource name.
// options - ContainersClientGetOptions contains the optional parameters for the ContainersClient.Get method.
func (client *ContainersClient) Get(ctx context.Context, resourceGroup string, fluidRelayServerName string, fluidRelayContainerName string, options *ContainersClientGetOptions) (ContainersClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroup, fluidRelayServerName, fluidRelayContainerName, options)
	if err != nil {
		return ContainersClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ContainersClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ContainersClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ContainersClient) getCreateRequest(ctx context.Context, resourceGroup string, fluidRelayServerName string, fluidRelayContainerName string, options *ContainersClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.FluidRelay/fluidRelayServers/{fluidRelayServerName}/fluidRelayContainers/{fluidRelayContainerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroup == "" {
		return nil, errors.New("parameter resourceGroup cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroup}", url.PathEscape(resourceGroup))
	if fluidRelayServerName == "" {
		return nil, errors.New("parameter fluidRelayServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fluidRelayServerName}", url.PathEscape(fluidRelayServerName))
	if fluidRelayContainerName == "" {
		return nil, errors.New("parameter fluidRelayContainerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fluidRelayContainerName}", url.PathEscape(fluidRelayContainerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ContainersClient) getHandleResponse(resp *http.Response) (ContainersClientGetResponse, error) {
	result := ContainersClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Container); err != nil {
		return ContainersClientGetResponse{}, err
	}
	return result, nil
}

// NewListByFluidRelayServersPager - List all Fluid Relay containers which are children of a given Fluid Relay server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-01
// resourceGroup - The resource group containing the resource.
// fluidRelayServerName - The Fluid Relay server resource name.
// options - ContainersClientListByFluidRelayServersOptions contains the optional parameters for the ContainersClient.ListByFluidRelayServers
// method.
func (client *ContainersClient) NewListByFluidRelayServersPager(resourceGroup string, fluidRelayServerName string, options *ContainersClientListByFluidRelayServersOptions) *runtime.Pager[ContainersClientListByFluidRelayServersResponse] {
	return runtime.NewPager(runtime.PagingHandler[ContainersClientListByFluidRelayServersResponse]{
		More: func(page ContainersClientListByFluidRelayServersResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ContainersClientListByFluidRelayServersResponse) (ContainersClientListByFluidRelayServersResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByFluidRelayServersCreateRequest(ctx, resourceGroup, fluidRelayServerName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ContainersClientListByFluidRelayServersResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ContainersClientListByFluidRelayServersResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ContainersClientListByFluidRelayServersResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByFluidRelayServersHandleResponse(resp)
		},
	})
}

// listByFluidRelayServersCreateRequest creates the ListByFluidRelayServers request.
func (client *ContainersClient) listByFluidRelayServersCreateRequest(ctx context.Context, resourceGroup string, fluidRelayServerName string, options *ContainersClientListByFluidRelayServersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.FluidRelay/fluidRelayServers/{fluidRelayServerName}/fluidRelayContainers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroup == "" {
		return nil, errors.New("parameter resourceGroup cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroup}", url.PathEscape(resourceGroup))
	if fluidRelayServerName == "" {
		return nil, errors.New("parameter fluidRelayServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fluidRelayServerName}", url.PathEscape(fluidRelayServerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByFluidRelayServersHandleResponse handles the ListByFluidRelayServers response.
func (client *ContainersClient) listByFluidRelayServersHandleResponse(resp *http.Response) (ContainersClientListByFluidRelayServersResponse, error) {
	result := ContainersClientListByFluidRelayServersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ContainerList); err != nil {
		return ContainersClientListByFluidRelayServersResponse{}, err
	}
	return result, nil
}
