//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdatafactory

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ExposureControlClient contains the methods for the ExposureControl group.
// Don't use this type directly, use NewExposureControlClient() instead.
type ExposureControlClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewExposureControlClient creates a new instance of ExposureControlClient with the specified values.
// subscriptionID - The subscription identifier.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewExposureControlClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ExposureControlClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ExposureControlClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// GetFeatureValue - Get exposure control feature for specific location.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2018-06-01
// locationID - The location identifier.
// exposureControlRequest - The exposure control request.
// options - ExposureControlClientGetFeatureValueOptions contains the optional parameters for the ExposureControlClient.GetFeatureValue
// method.
func (client *ExposureControlClient) GetFeatureValue(ctx context.Context, locationID string, exposureControlRequest ExposureControlRequest, options *ExposureControlClientGetFeatureValueOptions) (ExposureControlClientGetFeatureValueResponse, error) {
	req, err := client.getFeatureValueCreateRequest(ctx, locationID, exposureControlRequest, options)
	if err != nil {
		return ExposureControlClientGetFeatureValueResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ExposureControlClientGetFeatureValueResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ExposureControlClientGetFeatureValueResponse{}, runtime.NewResponseError(resp)
	}
	return client.getFeatureValueHandleResponse(resp)
}

// getFeatureValueCreateRequest creates the GetFeatureValue request.
func (client *ExposureControlClient) getFeatureValueCreateRequest(ctx context.Context, locationID string, exposureControlRequest ExposureControlRequest, options *ExposureControlClientGetFeatureValueOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DataFactory/locations/{locationId}/getFeatureValue"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if locationID == "" {
		return nil, errors.New("parameter locationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{locationId}", url.PathEscape(locationID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, exposureControlRequest)
}

// getFeatureValueHandleResponse handles the GetFeatureValue response.
func (client *ExposureControlClient) getFeatureValueHandleResponse(resp *http.Response) (ExposureControlClientGetFeatureValueResponse, error) {
	result := ExposureControlClientGetFeatureValueResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ExposureControlResponse); err != nil {
		return ExposureControlClientGetFeatureValueResponse{}, err
	}
	return result, nil
}

// GetFeatureValueByFactory - Get exposure control feature for specific factory.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2018-06-01
// resourceGroupName - The resource group name.
// factoryName - The factory name.
// exposureControlRequest - The exposure control request.
// options - ExposureControlClientGetFeatureValueByFactoryOptions contains the optional parameters for the ExposureControlClient.GetFeatureValueByFactory
// method.
func (client *ExposureControlClient) GetFeatureValueByFactory(ctx context.Context, resourceGroupName string, factoryName string, exposureControlRequest ExposureControlRequest, options *ExposureControlClientGetFeatureValueByFactoryOptions) (ExposureControlClientGetFeatureValueByFactoryResponse, error) {
	req, err := client.getFeatureValueByFactoryCreateRequest(ctx, resourceGroupName, factoryName, exposureControlRequest, options)
	if err != nil {
		return ExposureControlClientGetFeatureValueByFactoryResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ExposureControlClientGetFeatureValueByFactoryResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ExposureControlClientGetFeatureValueByFactoryResponse{}, runtime.NewResponseError(resp)
	}
	return client.getFeatureValueByFactoryHandleResponse(resp)
}

// getFeatureValueByFactoryCreateRequest creates the GetFeatureValueByFactory request.
func (client *ExposureControlClient) getFeatureValueByFactoryCreateRequest(ctx context.Context, resourceGroupName string, factoryName string, exposureControlRequest ExposureControlRequest, options *ExposureControlClientGetFeatureValueByFactoryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/getFeatureValue"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if factoryName == "" {
		return nil, errors.New("parameter factoryName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{factoryName}", url.PathEscape(factoryName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, exposureControlRequest)
}

// getFeatureValueByFactoryHandleResponse handles the GetFeatureValueByFactory response.
func (client *ExposureControlClient) getFeatureValueByFactoryHandleResponse(resp *http.Response) (ExposureControlClientGetFeatureValueByFactoryResponse, error) {
	result := ExposureControlClientGetFeatureValueByFactoryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ExposureControlResponse); err != nil {
		return ExposureControlClientGetFeatureValueByFactoryResponse{}, err
	}
	return result, nil
}

// QueryFeatureValuesByFactory - Get list of exposure control features for specific factory.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2018-06-01
// resourceGroupName - The resource group name.
// factoryName - The factory name.
// exposureControlBatchRequest - The exposure control request for list of features.
// options - ExposureControlClientQueryFeatureValuesByFactoryOptions contains the optional parameters for the ExposureControlClient.QueryFeatureValuesByFactory
// method.
func (client *ExposureControlClient) QueryFeatureValuesByFactory(ctx context.Context, resourceGroupName string, factoryName string, exposureControlBatchRequest ExposureControlBatchRequest, options *ExposureControlClientQueryFeatureValuesByFactoryOptions) (ExposureControlClientQueryFeatureValuesByFactoryResponse, error) {
	req, err := client.queryFeatureValuesByFactoryCreateRequest(ctx, resourceGroupName, factoryName, exposureControlBatchRequest, options)
	if err != nil {
		return ExposureControlClientQueryFeatureValuesByFactoryResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ExposureControlClientQueryFeatureValuesByFactoryResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ExposureControlClientQueryFeatureValuesByFactoryResponse{}, runtime.NewResponseError(resp)
	}
	return client.queryFeatureValuesByFactoryHandleResponse(resp)
}

// queryFeatureValuesByFactoryCreateRequest creates the QueryFeatureValuesByFactory request.
func (client *ExposureControlClient) queryFeatureValuesByFactoryCreateRequest(ctx context.Context, resourceGroupName string, factoryName string, exposureControlBatchRequest ExposureControlBatchRequest, options *ExposureControlClientQueryFeatureValuesByFactoryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/queryFeaturesValue"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if factoryName == "" {
		return nil, errors.New("parameter factoryName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{factoryName}", url.PathEscape(factoryName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, exposureControlBatchRequest)
}

// queryFeatureValuesByFactoryHandleResponse handles the QueryFeatureValuesByFactory response.
func (client *ExposureControlClient) queryFeatureValuesByFactoryHandleResponse(resp *http.Response) (ExposureControlClientQueryFeatureValuesByFactoryResponse, error) {
	result := ExposureControlClientQueryFeatureValuesByFactoryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ExposureControlBatchResponse); err != nil {
		return ExposureControlClientQueryFeatureValuesByFactoryResponse{}, err
	}
	return result, nil
}
