//! [snippet1]
// We include what we need for the test
#include <gatb/gatb_core.hpp>

using namespace std;

/********************************************************************************/
/*                              Sorting count                                   */
/*                                                                              */
/* This snippet shows how read the file generated by the sorting count algo.    */
/*                                                                              */
/* Cmd-line: kmer10 -in <fasta/q file>                                           */
/*                                                                              */
/* Sample: kmer10 -in gatb-core/gatb-core/test/db/reads1.fa                     */
/*                                                                              */
/********************************************************************************/
int main (int argc, char* argv[])
{
    // We create a command line parser.
    OptionsParser parser ("SortingCount");
    parser.push_back (new OptionOneParam (STR_URI_INPUT, "sorting count input", true));

    try
    {
        // Shortcuts.
        typedef Kmer<>::Count Count;
        typedef Kmer<>::Type  Type;

        // We parse the user options.
        IProperties* options = parser.parse (argc, argv);

        // We load the object storing the couples [kmer,abundance]
        Storage* storage = StorageFactory(STORAGE_HDF5).load (options->getStr(STR_URI_INPUT));   LOCAL (storage);

        // We get the group inside the storage object
        Group& dskGroup = storage->getGroup("dsk");

        // We retrieve the partition holding the couples [kmer,abundance]
        Partition<Count>& solidKmers = dskGroup.getPartition<Count> ("solid");

        // Now, we read the couples in two ways, computing a checksum in each case.
        Type checksum1, checksum2;

        // CASE 1: we read the couples [kmer,abundance] with an iterator over the whole partition
        Iterator<Count>* it = solidKmers.iterator();  LOCAL (it);
        for (it->first(); !it->isDone(); it->next())   {   checksum1 = checksum1 + it->item().value;  }

        // CASE 2: we read the couples [kmer,abundance] with an iterator over each collection of the partition
        for (size_t i=0; i<solidKmers.size(); i++)
        {
            // We get the current collection inside the partition
            Collection<Count>& collection = solidKmers [i];

            Iterator<Count>* it = collection.iterator();  LOCAL (it);
            for (it->first(); !it->isDone(); it->next())   {   checksum2 = checksum2 + it->item().value;  }
        }

        // We check that we got the same checksum
        cout << "checksum1=" << checksum1 << endl;
        cout << "checksum2=" << checksum1 << endl;
    }
    catch (OptionFailure& e)
    {
        return e.displayErrors (std::cout);
    }
    catch (Exception& e)
    {
        std::cerr << "EXCEPTION: " << e.getMessage() << std::endl;
    }

    return EXIT_SUCCESS;
}
//! [snippet1]
