/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl.engine;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.IStateMachineDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IConnectionPointReference;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IEntryPointPseudoState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IExitPointPseudoState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IRegion;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateMachine;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateVertex;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;

public class StateUpdater {
    public boolean createStateMachineFromState(IModelingSession session, IState state) {
        IRegion region = state.getParent();
        IElement element = region.getCompositionOwner();
        while (!(element instanceof IStateMachine)) {
            element = element.getCompositionOwner().getCompositionOwner();
        }
        INameSpace creationDestination = ((IStateMachine)element).getOwner();
        IStateMachine stateMachine = session.getModel().createStateMachine();
        creationDestination.addOwnedBehavior((IBehavior)stateMachine);
        stateMachine.setName(state.getName());
        try {
            IStateMachineDiagram diagram = session.getModel().createStateMachineDiagram(stateMachine.getName(), (IModelElement)stateMachine, null);
            diagram.setOrigin((IModelElement)stateMachine);
            diagram.setOwner(session.getModel().getUmlProject().getDiagramRoot());
        }
        catch (StereotypeNotFoundException e) {
            e.printStackTrace(Modelio.err);
            return false;
        }
        IRegion topRegion = stateMachine.getTop();
        for (IConnectionPointReference connectionPoint : state.getConnection()) {
            if (connectionPoint.getEntry() != null) {
                this.createEntry(session, (IStateVertex)connectionPoint, topRegion);
                continue;
            }
            if (connectionPoint.getExit() != null) {
                this.createExit(session, (IStateVertex)connectionPoint, topRegion);
                continue;
            }
            int entryTransition = connectionPoint.getIncoming().size();
            int exitTransition = connectionPoint.getOutGoing().size();
            if (entryTransition > 0 && exitTransition == 0) {
                this.createEntry(session, (IStateVertex)connectionPoint, topRegion);
                continue;
            }
            if (exitTransition <= 0 || entryTransition != 0) continue;
            this.createExit(session, (IStateVertex)connectionPoint, topRegion);
        }
        for (IEntryPointPseudoState entry : state.getEntryPoint()) {
            this.createEntry(session, (IStateVertex)entry, topRegion);
        }
        for (IExitPointPseudoState exit : state.getExitPoint()) {
            this.createExit(session, (IStateVertex)exit, topRegion);
        }
        return true;
    }

    private void createExit(IModelingSession session, IStateVertex vertex, IRegion topRegion) {
        IExitPointPseudoState exit = Modelio.getInstance().getModelingSession().getModel().createExitPointPseudoState();
        topRegion.addSub((IStateVertex)exit);
        exit.setName(vertex.getName());
    }

    private void createEntry(IModelingSession session, IStateVertex vertex, IRegion topRegion) {
        IEntryPointPseudoState entry = Modelio.getInstance().getModelingSession().getModel().createEntryPointPseudoState();
        topRegion.addSub((IStateVertex)entry);
        entry.setName(vertex.getName());
    }

    public void updateStateFromStateMachine(IModelingSession session, IState state) {
        IStateMachine stateMachine = state.getSubMachine();
        if (stateMachine != null) {
            IRegion smTop = stateMachine.getTop();
            ObList existingEntries = smTop.getSub(IEntryPointPseudoState.class);
            ObList existingExits = smTop.getSub(IExitPointPseudoState.class);
            boolean found = false;
            for (IConnectionPointReference pointReference : state.getConnection()) {
                IExitPointPseudoState exit;
                IEntryPointPseudoState entry = pointReference.getEntry();
                if (entry != null) {
                    if (entry.getParent().equals((Object)smTop)) {
                        pointReference.setName(entry.getName());
                        found = true;
                        break;
                    }
                    for (IEntryPointPseudoState existingEntry : smTop.getSub(IEntryPointPseudoState.class)) {
                        if (!existingEntry.getName().equals(entry.getName())) continue;
                        found = true;
                        pointReference.setEntry(existingEntry);
                        existingEntries.remove(existingEntry);
                        break;
                    }
                }
                if ((exit = pointReference.getExit()) != null) {
                    if (exit.getParent().equals((Object)smTop)) {
                        pointReference.setName(exit.getName());
                        found = true;
                        break;
                    }
                    for (IExitPointPseudoState existingExit : smTop.getSub(IExitPointPseudoState.class)) {
                        if (!existingExit.getName().equals(exit.getName())) continue;
                        found = true;
                        pointReference.setExit(existingExit);
                        existingExits.remove(existingExit);
                        break;
                    }
                }
                if (found) continue;
                pointReference.delete();
            }
            for (IEntryPointPseudoState existingEntry : existingEntries) {
                this.createConnectionPoint(session, state, existingEntry);
            }
            for (IExitPointPseudoState existingExit : existingExits) {
                this.createConnectionPoint(session, state, existingExit);
            }
        }
    }

    private IConnectionPointReference createConnectionPoint(IModelingSession session, IState state, IExitPointPseudoState exit) {
        IConnectionPointReference newPoint = session.getModel().createConnectionPointReference();
        state.addConnection(newPoint);
        newPoint.setExit(exit);
        newPoint.setName(exit.getName());
        return newPoint;
    }

    private IConnectionPointReference createConnectionPoint(IModelingSession session, IState state, IEntryPointPseudoState entry) {
        IConnectionPointReference newPoint = session.getModel().createConnectionPointReference();
        state.addConnection(newPoint);
        newPoint.setEntry(entry);
        newPoint.setName(entry.getName());
        return newPoint;
    }
}

