
#ifndef EL__OSDEP_BEOS_OVERRIDES_H
#define EL__OSDEP_BEOS_OVERRIDES_H

#ifdef CONFIG_OS_BEOS

#include <sys/time.h>
#include <sys/types.h>
#include <net/socket.h>

#ifdef __cplusplus
extern "C" {
#endif

int be_socket(int, int, int);
int be_connect(int, struct sockaddr *, int);
int be_getpeername(int, struct sockaddr *, int *);
int be_getsockname(int, struct sockaddr *, int *);
int be_listen(int, int);
int be_accept(int, struct sockaddr *, int *);
int be_bind(int, struct sockaddr *, int);
int be_pipe(int *);
int be_read(int, void *, int);
int be_write(int, void *, int);
int be_close(int);
int be_select(int, struct fd_set *, struct fd_set *, struct fd_set *, struct timeval *);
int be_getsockopt(int, int, int, void *, int *);

#ifndef BEOS_SELF
#define socket be_socket
#define connect be_connect
#define getpeername be_getpeername
#define getsockname be_getsockname
#define listen be_listen
#define accept be_accept
#define bind be_bind
#define pipe be_pipe
#define read be_read
#define write be_write
#define close be_close
#define select be_select
#define getsockopt be_getsockopt
#ifdef errno
#undef errno
#endif
#define errno 1
#endif

#ifdef __cplusplus
}
#endif

#endif

#endif
