# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Rename ``arch_all_host_architecture`` to ``arch_all_build_architecture``."""

from django.db import migrations

from debusine.artifacts.models import TaskTypes
from debusine.db.migrations._utils import (
    make_work_request_task_data_field_renamer,
    make_workflow_template_task_data_field_renamer,
)

affected_workflows = {
    "autopkgtest",
    "blhc",
    "debdiff",
    "debian_pipeline",
    "lintian",
    "package_upload",
    "piuparts",
    "qa",
    "reverse_dependencies_autopkgtest",
    "sbuild",
}


class Migration(migrations.Migration):
    dependencies = [
        ("db", "0027_rename_worker_static_native_architecture"),
    ]

    operations = [
        make_work_request_task_data_field_renamer(
            TaskTypes.WORKFLOW,
            affected_workflows,
            [("arch_all_host_architecture", "arch_all_build_architecture")],
        ),
        make_workflow_template_task_data_field_renamer(
            affected_workflows,
            [("arch_all_host_architecture", "arch_all_build_architecture")],
        ),
    ]
