info = {
    "name": "se",
    "date_order": "YMD",
    "january": [
        "ođđajagemánnu",
        "ođđj"
    ],
    "february": [
        "guovvamánnu",
        "guov"
    ],
    "march": [
        "njukčamánnu",
        "njuk"
    ],
    "april": [
        "cuoŋománnu",
        "cuo"
    ],
    "may": [
        "miessemánnu",
        "mies"
    ],
    "june": [
        "geassemánnu",
        "geas"
    ],
    "july": [
        "suoidnemánnu",
        "suoi"
    ],
    "august": [
        "borgemánnu",
        "borg"
    ],
    "september": [
        "čakčamánnu",
        "čakč"
    ],
    "october": [
        "golggotmánnu",
        "golg"
    ],
    "november": [
        "skábmamánnu",
        "skáb"
    ],
    "december": [
        "juovlamánnu",
        "juov"
    ],
    "monday": [
        "vuossárga",
        "vuos"
    ],
    "tuesday": [
        "maŋŋebárga",
        "maŋ"
    ],
    "wednesday": [
        "gaskavahkku",
        "gask"
    ],
    "thursday": [
        "duorasdat",
        "duor"
    ],
    "friday": [
        "bearjadat",
        "bear"
    ],
    "saturday": [
        "lávvardat",
        "láv"
    ],
    "sunday": [
        "sotnabeaivi",
        "sotn"
    ],
    "am": [
        "iđitbeaivi",
        "ib",
        "iđitbeaivet"
    ],
    "pm": [
        "eahketbeaivi",
        "eb",
        "eahketbeaivet"
    ],
    "year": [
        "jáhki"
    ],
    "month": [
        "mánnu"
    ],
    "week": [
        "váhkku"
    ],
    "day": [
        "beaivi"
    ],
    "hour": [
        "diibmu"
    ],
    "minute": [
        "minuhtta"
    ],
    "second": [
        "sekunda"
    ],
    "relative-type": {
        "1 year ago": [
            "last year"
        ],
        "0 year ago": [
            "this year"
        ],
        "in 1 year": [
            "next year"
        ],
        "1 month ago": [
            "last month"
        ],
        "0 month ago": [
            "this month"
        ],
        "in 1 month": [
            "next month"
        ],
        "1 week ago": [
            "last week"
        ],
        "0 week ago": [
            "this week"
        ],
        "in 1 week": [
            "next week"
        ],
        "1 day ago": [
            "ikte"
        ],
        "0 day ago": [
            "odne"
        ],
        "in 1 day": [
            "ihttin"
        ],
        "0 hour ago": [
            "this hour"
        ],
        "0 minute ago": [
            "this minute"
        ],
        "0 second ago": [
            "now"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) jahki maŋŋilit",
            "(\\d+) jahkki maŋŋilit"
        ],
        "\\1 year ago": [
            "(\\d+) jahki árat",
            "(\\d+) jahkki árat"
        ],
        "in \\1 month": [
            "(\\d+) mánotbadji maŋŋilit"
        ],
        "\\1 month ago": [
            "(\\d+) mánotbadji árat"
        ],
        "in \\1 week": [
            "(\\d+) vahku maŋŋilit",
            "(\\d+) vahkku maŋŋilit"
        ],
        "\\1 week ago": [
            "(\\d+) vahku árat",
            "(\\d+) vahkku árat"
        ],
        "in \\1 day": [
            "(\\d+) jándor maŋŋilit",
            "(\\d+) jándora maŋŋilit"
        ],
        "\\1 day ago": [
            "(\\d+) jándor árat",
            "(\\d+) jándora árat"
        ],
        "in \\1 hour": [
            "(\\d+) diibmu maŋŋilit",
            "(\\d+) diibmur maŋŋilit"
        ],
        "\\1 hour ago": [
            "(\\d+) diibmu árat",
            "(\\d+) diibmur árat"
        ],
        "in \\1 minute": [
            "(\\d+) minuhta maŋŋilit",
            "(\\d+) minuhtta maŋŋilit"
        ],
        "\\1 minute ago": [
            "(\\d+) minuhta árat",
            "(\\d+) minuhtta árat"
        ],
        "in \\1 second": [
            "(\\d+) sekunda maŋŋilit",
            "(\\d+) sekundda maŋŋilit"
        ],
        "\\1 second ago": [
            "(\\d+) sekunda árat",
            "(\\d+) sekundda árat"
        ]
    },
    "locale_specific": {
        "se-FI": {
            "name": "se-FI",
            "monday": [
                "vuossárgga"
            ],
            "tuesday": [
                "maŋŋebárgga"
            ],
            "wednesday": [
                "gaskavahku"
            ],
            "thursday": [
                "duorastaga"
            ],
            "friday": [
                "bearjadaga"
            ],
            "saturday": [
                "lávvardaga"
            ],
            "year": [
                "jahki",
                "j"
            ],
            "week": [
                "vahkku"
            ],
            "relative-type": {
                "1 year ago": [
                    "mannan jagi"
                ],
                "0 year ago": [
                    "dán jagi"
                ],
                "in 1 year": [
                    "boahtte jagi"
                ]
            },
            "relative-type-regex": {
                "in \\1 year": [
                    "(\\d+) jagi siste"
                ],
                "\\1 year ago": [
                    "(\\d+) jagi árat"
                ]
            }
        },
        "se-SE": {
            "name": "se-SE"
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
